Attribute VB_Name = "MdlFileRdWt"
Option Explicit

Public Const cnt_CSV_SEPA_CHAR = ","
Public Const cnt_CSV_SEPA_2ndCHAR = ";"

Public Const cnt_CSV_WRITE_VER1000 = "1.000"    'Analysis Ver 1.000
Public Const cnt_CSV_WRITE_VER2000 = "2.000"    'Analysis Ver 2.000
Public Const cnt_CSV_WRITE_VER = "3.000"        'Analysis Ver 3.000

Public Const cnt_CHECK_APPLI_NAME = "ANT_Para"

Public Const cnt_SEG_NO___TITLE = "Segment Number"
Public Const cnt_FRQ_SEGM_TITLE = "Number of Freq.Segment"
Public Const cnt_FRQ_STAR_TITLE = "START[MHz]"
Public Const cnt_FRQ_STOP_TITLE = "STOP[MHz]"
Public Const cnt_FRQ_POIN_TITLE = "POINT"
Public Const cnt_FRQ_STPW_TITLE = "START POWER[dBm]"
Public Const cnt_FRQ_SPPW_TITLE = "STOP POWER[dBm]"
Public Const cnt_FRQ_RBW__TITLE = "RBW[KHZ]"
Public Const cnt_FRQ_STTM_TITLE = "SettlingTime[msec]"

Public Const cnt_MEAS_NUM_TITLE = "Number of Measurement"
Public Const cnt_MEAS_NO_TITLE = "Measurement Number"
Public Const cnt_MEAS_TT_TITLE = "TITLE"
Public Const cnt_MEAS_JG_TITLE = "Judge Valid(ON)/Invalid(OFF)"
Public Const cnt_MEAS_TN_TITLE = "Trace Number"
Public Const cnt_MEAS_CM_TITLE = "Meas. Command"
Public Const cnt_MEAS_ST_TITLE = "START[MHz]"
Public Const cnt_MEAS_SP_TITLE = "STOP[MHz]"
Public Const cnt_MEAS_LD_TITLE = "Limit Disp"
Public Const cnt_MEAS_LC_TITLE = "LowerLimit Check"
Public Const cnt_MEAS_LW_TITLE = "LowerLimit"
Public Const cnt_MEAS_UC_TITLE = "UpperLimit Check"
Public Const cnt_MEAS_UP_TITLE = "UpperLimit"
Public Const cnt_MEAS_LF_TITLE = "Lw Freq[MHz]"
Public Const cnt_MEAS_UF_TITLE = "Up Freq[MHz]"

Public Const cnt_FREQ_TO_STR = "0.0000000000E-0"
Public Const cnt_FREQ_ADJUST As Double = 0.00000000005

Public Const cnt_RBW_TO_STR = "0.000000E-0"
Public Const cnt_RBW_ADJUST As Double = 0.0000005

Public Const cnt_STTM_TO_STR = "0.000000E-0"
Public Const cnt_STTM_ADJUST As Double = 0.0000005

Public Const cnt_LEVL_TO_STR = "0.000000E-0"

Public Const cnt_INT_TO_STR As Integer = 0
Public Const cnt_STR_TO_INT As Integer = 1

Public Const cnt_READ As Integer = 0
Public Const cnt_SAVE As Integer = 1

Public Const Unit_OpenZ0 = 0
Public Const Unit_OpenDelay = 1
Public Const Unit_OpenLoss = 2
Public Const Unit_OpenCapC0 = 3
Public Const Unit_OpenCapC1 = 4
Public Const Unit_OpenCapC2 = 5
Public Const Unit_OpenCapC3 = 6
Public Const Unit_ShortZ0 = 7
Public Const Unit_ShortDelay = 8
Public Const Unit_ShortLoss = 9
Public Const Unit_ShortIndL0 = 10
Public Const Unit_ShortIndL1 = 11
Public Const Unit_ShortIndL2 = 12
Public Const Unit_ShortIndL3 = 13
Public Const Unit_LoadZ0 = 14
Public Const Unit_LoadDelay = 15
Public Const Unit_LoadLoss = 16
Public Const Unit_LoadResistance = 17

Public Const Unit_OpenR = 0
Public Const Unit_OpenL = 1
Public Const Unit_OpenC = 2
Public Const Unit_ShortR = 7
Public Const Unit_ShortL = 8
Public Const Unit_ShortC = 9
Public Const Unit_LoadR = 14
Public Const Unit_LoadL = 15
Public Const Unit_LoadC = 16

Public Const GOHM = 1000000000#
Public Const PS = 0.000000000001

Public Const CapC0 = 0.000000000000001
Public Const CapC1 = 1E-27
Public Const CapC2 = 1E-36
Public Const CapC3 = 1E-45
Public Const IndL0 = 0.000000000001
Public Const IndL1 = 1E-24
Public Const IndL2 = 1E-33
Public Const IndL3 = 1E-42

Public Const cnt_APP_NAME_TITLE = "Application Name"
Public Const cnt_CSV_SHET_TITLE = "CSV Sheet Revsion"
Public Const cnt_BD__NUMB_TITLE = "Board Number"
Public Const cnt_IP__ADDR_TITLE = "IP Address"
Public Const cnt_PD__NAME_TITLE = "Product Name"
Public Const cnt_PD_SERNO_TITLE = "Serial Number"
Public Const cnt_PD_NUMCH_TITLE = "Number Of Channel"
Public Const cnt_CH__NO___TITLE = "Channel Title"
Public Const cnt_CAL_COR__TITLE = "CAL status (Cor/C?/C!)"
Public Const cnt_STIM_NUM_TITLE = "Number of Freq.Segment"
Public Const cnt_MEAS_____TITLE = "Measurement"
Public Const cnt_FMT_LGM__TITLE = "LOGMAG"
Public Const cnt_FMT_INF__TITLE = "Information on format "
Public Const cnt_FMT_DIV__TITLE = "/DIV"
Public Const cnt_FMT_REFV_TITLE = "Ref.VAL"
Public Const cnt_FMT_REFP_TITLE = "Ref.Pos"
Public Const cnt_LIMIT__F_TITLE = "Limit Line Freq"
Public Const cnt_LMT_CHKF_TITLE = "Check Freq"
Public Const cnt_LMT_LFRQ_TITLE = "Lw Freq"
Public Const cnt_LMT_LFP__TITLE = "Lw Freq Point"
Public Const cnt_LMT_UFRQ_TITLE = "Up Freq"
Public Const cnt_LMT_UFP__TITLE = "Up Freq Point"
Public Const cnt_LMT_FRQ__TITLE = "Freq"
Public Const cnt_LIMIT__L_TITLE = "Limit Line Level"
Public Const cnt_LMT_C_LW_TITLE = "Check Lw Level"
Public Const cnt_LMT_LWLV_TITLE = "Lw Level"
Public Const cnt_LMT_C_UP_TITLE = "Check Up Level"
Public Const cnt_LMT_UPLV_TITLE = "Up Level"
Public Const cnt_LMT_LVL__TITLE = "Level"

Public Const cnt_FILE_NOT_RE As Integer = 0             ' intFileRecall : Not Recall
Public Const cnt_FILE_RECALL As Integer = 1             ' intFileRecall : Recall

Private Declare Sub PathRemoveExtension Lib "SHLWAPI.DLL" Alias "PathRemoveExtensionA" (ByVal pszPath As String)

'************************************
'   Only API file name is taken out.
'************************************
Public Function FindFileName(ByVal strFileName As String) As String
    Dim strBuffer   As String
    Dim lngResult   As Long
    Dim bytStr()    As Byte

    lngResult = PathFindFileName(strFileName)
    If lngResult <> 0 Then
        ReDim bytStr(MAX_PATH + 1) As Byte
        MoveMemory bytStr(0), ByVal lngResult, MAX_PATH + 1
        strBuffer = StrConv(bytStr(), vbUnicode)
        FindFileName = Left$(strBuffer, InStr(strBuffer, vbNullChar) - 1)
    End If
End Function

'
' gq菜
'
Public Function RemoveExtension(ByVal strFileName As String) As String
    ' strFileName : t@C
    ' ߂l      : gq菜ꂽt@CԂB

    PathRemoveExtension strFileName
    If 0 < InStr(strFileName, vbNullChar) Then
        RemoveExtension = Left$(strFileName, InStr(strFileName, vbNullChar) - 1)
    Else
        RemoveExtension = strFileName
    End If
End Function

'
' One-line read & line counter
'
Private Function getline(ByRef fileno As Long, ByVal lcnt As Long, ByRef aryTemp As Variant, ByRef s As String) As Long
    Dim textline As Variant
    
    lcnt = lcnt + 1
    Line Input #fileno, textline
    If 0 < InStr(1, textline, cnt_CSV_SEPA_2ndCHAR) Then s = cnt_CSV_SEPA_2ndCHAR
    aryTemp = Split(textline, s)
    getline = lcnt
End Function
'
' Reading of measurement condition from CSV Sheet
'
Private Function getdata(ByRef fileno As Long, ByVal lcnt As Long, ByRef vntTemp As Variant, ByRef s As String) As Long
    Dim lngTemp As Long

    lcnt = getline(fileno, lcnt, vntTemp, s)
    getdata = lcnt
End Function

'
'The value of ON/OFF or the character string is returned.
'
Public Sub CnvOnOffSw(ByVal flg As Integer, ByRef ss As String, ByRef sw As Integer)

    If flg = cnt_INT_TO_STR Then    'sw ->  return ss  = "ON" or "OFF"
        Select Case sw
            Case 0: ss = "OFF"
            Case 1: ss = "ON"
            Case Else: ss = "OFF"
        End Select
    Else                            ' ss -> return sw  = 0 or 1
        Select Case UCase$(ss)
            Case "OFF": sw = 0
            Case "ON": sw = 1
            Case Else: sw = -1
        End Select
    End If

End Sub

Private Function RdWtData(ByRef fno As Long, ByVal line_cnt As Long, ByRef vntData As Variant, ByRef s As String, ByVal rdwt_flg As Integer) As Long
    
    If rdwt_flg = cnt_READ Then
        line_cnt = getdata(fno, line_cnt, vntData, s)
    Else
        Write #fno, vntData
        line_cnt = line_cnt + 1
    End If
    
    RdWtData = line_cnt

End Function


Public Function dblRound(ByVal dt As Double, ByVal div_dt As Double, adj_dt As Double) As Double
    Dim l As Long
    Dim tmp As Double

    If dt = 0 Then
        dblRound = dt
    Else
        l = Fix(dt / div_dt)
        tmp = dt / div_dt - CDbl(l)
        If tmp = 0 Or dt = dt / div_dt * div_dt Then
            dblRound = dt / div_dt
        Else
            dblRound = dt / div_dt + adj_dt
        End If
    End If
End Function

'
'FORMATŎgplT[`
'
Public Function CnvFormatNameToType(ss As String) As Long
    Select Case UCase(ss)
        Case "LOGMAG": CnvFormatNameToType = WAVE_FORMAT_LOGMAG
        Case "PHASE": CnvFormatNameToType = WAVE_FORMAT__PHASE
        Case "POLAR": CnvFormatNameToType = WAVE_FORMAT__POLAR
        Case "SMITH": CnvFormatNameToType = WAVE_FORMAT__SMITH
        Case "DELAY": CnvFormatNameToType = WAVE_FORMAT__DELAY
        Case "SWR": CnvFormatNameToType = WAVE_FORMAT____SWR
        Case "REAL": CnvFormatNameToType = WAVE_FORMAT___REAL
        Case "IMAG": CnvFormatNameToType = WAVE_FORMAT___IMAG
        Case Else
            CnvFormatNameToType = WAVE_FORMAT____NON
    End Select
End Function

'
'FORMATŎgpXP[l̐ݒ
'
Public Sub CnvFormatNameToScale(tscl As struct_Trace, ss As String, dblDiv As Double, dblRef As Double, dblPos As Double)
    Select Case UCase(ss)
        Case "LOGMAG":
            tscl.FmtScale.Mscl.div = dblDiv: tscl.FmtScale.Mscl.ref = dblRef: tscl.FmtScale.Mscl.pos = dblPos
        Case "PHASE":
            tscl.FmtScale.Pscl.div = dblDiv: tscl.FmtScale.Pscl.ref = dblRef: tscl.FmtScale.Pscl.pos = dblPos
        Case "POLAR":
        Case "SMITH":
        Case "DELAY":
            tscl.FmtScale.Dscl.div = dblDiv: tscl.FmtScale.Dscl.ref = dblRef: tscl.FmtScale.Dscl.pos = dblPos
        Case "SWR":
            tscl.FmtScale.SWRscl.div = dblDiv: tscl.FmtScale.SWRscl.ref = dblRef: tscl.FmtScale.SWRscl.pos = dblPos
        Case "REAL":
            tscl.FmtScale.Rscl.div = dblDiv: tscl.FmtScale.Rscl.ref = dblRef: tscl.FmtScale.Rscl.pos = dblPos
        Case "IMAG":
            tscl.FmtScale.Iscl.div = dblDiv: tscl.FmtScale.Iscl.ref = dblRef: tscl.FmtScale.Iscl.pos = dblPos
    End Select
End Sub

'
' LCR R}ĥƂ́ALogmag + Smith(real + imag) ̔g`擾悤ɕԂB
'
Public Function GetMeasType(ByVal flg As Integer, ByRef sstype As String, ByRef meas_type As Long, ByRef dlvl As Double) As Long
    Dim str As String
    
    On Error GoTo err_GetMeasType

    GetMeasType = 0
    
    dlvl = 0
    If flg = cnt_INT_TO_STR Then    'sstype -> return meas_type  = "MAX" or "MIN" or "VAL" or "PWRVAL"
        Select Case meas_type
            Case McrMeasMAX: sstype = "MAX"
            Case McrMeasMIN: sstype = "MIN"
            Case McrMeasVAL: sstype = "VAL"
            Case McrMeasPWRVAL: sstype = "PWRVAL"
            Case McrMeasPKF0: sstype = "PKF0"
            Case McrMeasPKLF: sstype = "PKLF"
            Case McrMeasPKHF: sstype = "PKHF"
            Case McrMeasPKBW: sstype = "PKBW"
            Case McrMeasSPF0: sstype = "SPF0"
            Case McrMeasSPLF: sstype = "SPLF"
            Case McrMeasSPHF: sstype = "SPHF"
            Case McrMeasSPBW: sstype = "SPBW"
            Case McrMeasRFF0: sstype = "RFF0"
            Case McrMeasRFLF: sstype = "RFLF"
            Case McrMeasRFHF: sstype = "RFHF"
            Case McrMeasRFBW: sstype = "RFBW"
            Case McrMeasTRGT: sstype = "TRGT"
            Case McrMeasVALL: sstype = "VAL_L"
            Case McrMeasVALC: sstype = "VAL_C"
            Case McrMeasVALR: sstype = "VAL_R"
            Case McrMeasRESMIN: sstype = "RES_MIN"
            Case McrMeasRESL: sstype = "RES_L"
            Case McrMeasRESC: sstype = "RES_C"
            Case McrMeasRESR: sstype = "RES_R"
            Case Else
                sstype = "VAL"
                Exit Function
        End Select
    Else                            'meas_type -> return sstype  =McrMeasMAX or McrMeasMIN or McrMeasVAL or McrMeasPWRVAL
        Select Case UCase(sstype)
            Case "MAX": meas_type = McrMeasMAX
            Case "MIN": meas_type = McrMeasMIN
            Case "VAL": meas_type = McrMeasVAL
            Case "VAL_L": meas_type = McrMeasVALL: GetMeasType = WAVE_FORMAT_LOGMAG Or WAVE_FORMAT__SMITH
            Case "VAL_C": meas_type = McrMeasVALC: GetMeasType = WAVE_FORMAT_LOGMAG Or WAVE_FORMAT__SMITH
            Case "VAL_R": meas_type = McrMeasVALR: GetMeasType = WAVE_FORMAT_LOGMAG Or WAVE_FORMAT__SMITH
            Case "RES_MIN": meas_type = McrMeasRESMIN: GetMeasType = WAVE_FORMAT_LOGMAG Or WAVE_FORMAT__SMITH
            Case "RES_L": meas_type = McrMeasRESL: GetMeasType = WAVE_FORMAT_LOGMAG Or WAVE_FORMAT__SMITH
            Case "RES_C": meas_type = McrMeasRESC: GetMeasType = WAVE_FORMAT_LOGMAG Or WAVE_FORMAT__SMITH
            Case "RES_R": meas_type = McrMeasRESR: GetMeasType = WAVE_FORMAT_LOGMAG Or WAVE_FORMAT__SMITH
            Case "PWRVAL": meas_type = McrMeasPWRVAL
            Case Else
                str = UCase(Mid$(sstype, 1, 4))
                Select Case str
                    Case "PKF0": meas_type = McrMeasPKF0
                    Case "PKLF": meas_type = McrMeasPKLF
                    Case "PKHF": meas_type = McrMeasPKHF
                    Case "PKBW": meas_type = McrMeasPKBW
                    Case "SPF0": meas_type = McrMeasSPF0
                    Case "SPLF": meas_type = McrMeasSPLF
                    Case "SPHF": meas_type = McrMeasSPHF
                    Case "SPBW": meas_type = McrMeasSPBW
                    Case "RFF0": meas_type = McrMeasRFF0
                    Case "RFLF": meas_type = McrMeasRFLF
                    Case "RFHF": meas_type = McrMeasRFHF
                    Case "RFBW": meas_type = McrMeasRFBW
                    Case "TRGT": meas_type = McrMeasTRGT
                    Case Else
                        meas_type = -1
                        Exit Function
                End Select
                dlvl = CDbl(Mid$(sstype, 5, Len(sstype)))   'l
        End Select
    End If
    

err_GetMeasType:
    On Error GoTo 0
End Function



Private Function GetTraceNo(ch As Long, ss As String) As Long
    
    Select Case UCase(ss)
        Case "LOGMAG": GetTraceNo = 1024 * ch + BIS_TRAC1_LOGMAG
        Case "PHASE": GetTraceNo = 1024 * ch + BIS_TRAC1_PHASE
        Case "POLAR": GetTraceNo = 1024 * ch + BIS_TRAC1_UDT_RE
        Case "SMITH": GetTraceNo = 1024 * ch + BIS_TRAC1_UDT_RE
        Case "DELAY": GetTraceNo = 1024 * ch + BIS_TRAC1_PHASE
        Case "SWR": GetTraceNo = 1024 * ch + BIS_TRAC1_LINMAG
        Case "REAL": GetTraceNo = 1024 * ch + BIS_TRAC1_UDT_RE
        Case "IMAG": GetTraceNo = 1024 * ch + BIS_TRAC1_UDT_IM
        Case Else
            GetTraceNo = 1024 * ch + BIS_TRAC1_LOGMAG
    End Select
        
End Function

'*************************************************
'  Function name  Fsubstdunit
'  Function    FUnit adjustment.
'  Functional descriptionsF
'*************************************************
Public Function substdunit(code As Integer) As Double
    Select Case code
        Case Unit_OpenL, Unit_ShortL, Unit_LoadL: substdunit = Unit_p   ' 1E-12 = p
        Case Unit_OpenC, Unit_ShortC, Unit_LoadC: substdunit = Unit_f   ' 1E-15 = f
        Case Else: substdunit = 1
    End Select

End Function

'*************************************************
'  Function name  Fsubunit
'  Function    FUnit adjustment.
'  Functional descriptionsF
'*************************************************
Public Function subunit(code As Integer) As Double
    
    Select Case code
        Case Unit_OpenDelay, Unit_ShortDelay, Unit_LoadDelay:
            subunit = PS
        Case Unit_OpenLoss, Unit_ShortLoss, Unit_LoadLoss:
            subunit = GOHM
            
        Case Unit_OpenCapC0: subunit = CapC0
        Case Unit_OpenCapC1: subunit = CapC1
        Case Unit_OpenCapC2: subunit = CapC2
        Case Unit_OpenCapC3: subunit = CapC3
        
        Case Unit_ShortIndL0: subunit = IndL0
        Case Unit_ShortIndL1: subunit = IndL1
        Case Unit_ShortIndL2: subunit = IndL2
        Case Unit_ShortIndL3: subunit = IndL3
        
        Case Else: subunit = 1
    End Select
    
End Function

Public Sub SetStdCalKit_Data(code As Integer, dt As Double)
    
    dt = dt * substdunit(code)
    
    With StdCKit
        Select Case code
                Case Unit_OpenR:        .opRs = dt
                Case Unit_OpenL:        .opLs = dt
                Case Unit_OpenC:        .opCp = dt
                Case Unit_ShortR:       .shRs = dt
                Case Unit_ShortL:       .shLs = dt
                Case Unit_ShortC:       .shCp = dt
                Case Unit_LoadR:        .loRs = dt
                Case Unit_LoadL:        .loLs = dt
                Case Unit_LoadC:        .loCp = dt
        End Select
    End With

End Sub

Public Sub SetUserDefCalKit_Data(code As Integer, dt As Double)
    
    dt = dt * subunit(code)
    
    Select Case code
        Case Unit_OpenZ0:           CKit.UserDef.op_imp = dt
        Case Unit_OpenDelay:        CKit.UserDef.op_del = dt
        Case Unit_OpenLoss:         CKit.UserDef.op_loss = dt
        Case Unit_OpenCapC0:        CKit.UserDef.dblCap(0) = dt
        Case Unit_OpenCapC1:        CKit.UserDef.dblCap(1) = dt
        Case Unit_OpenCapC2:        CKit.UserDef.dblCap(2) = dt
        Case Unit_OpenCapC3:        CKit.UserDef.dblCap(3) = dt
        Case Unit_ShortZ0:          CKit.UserDef.sh_imp = dt
        Case Unit_ShortDelay:       CKit.UserDef.sh_del = dt
        Case Unit_ShortLoss:        CKit.UserDef.sh_loss = dt
        Case Unit_ShortIndL0:       CKit.UserDef.dblind(0) = dt
        Case Unit_ShortIndL1:       CKit.UserDef.dblind(1) = dt
        Case Unit_ShortIndL2:       CKit.UserDef.dblind(2) = dt
        Case Unit_ShortIndL3:       CKit.UserDef.dblind(3) = dt
        Case Unit_LoadZ0:           CKit.UserDef.lo_imp = dt
        Case Unit_LoadDelay:        CKit.UserDef.lo_del = dt
        Case Unit_LoadLoss:         CKit.UserDef.lo_loss = dt
        Case Unit_LoadResistance:   CKit.UserDef.lo_res = dt
    End Select

End Sub


Public Sub ReadCalFile(ByVal mx_ch As Long, ByVal fn As String)
    Dim fileno As Long
    Dim i As Integer
    Dim ch As Integer

    fn = Mid(fn, 1, Len(fn) - 3)
    fn = fn & "bin"
    On Error GoTo rdcalerr
    
    fileno = FreeFile
    '
    Open fn For Binary Access Read As #fileno Len = Len(ChInfo(ACT_CH1).Correct.cal1(0))
        For ch = ACT_CH1 To mx_ch - 1
            With ChInfo(ch)
                For i = 0 To .lngTotP - 1
                    With .Correct
                        Get #fileno, , .cal1(i * 2)
                        Get #fileno, , .cal1(i * 2 + 1)
                        Get #fileno, , .cal2(i * 2)
                        Get #fileno, , .cal2(i * 2 + 1)
                        Get #fileno, , .cal3(i * 2)
                        Get #fileno, , .cal3(i * 2 + 1)
                    End With
                Next i
            End With
        Next ch
    Close #fileno
    On Error GoTo 0
    Exit Sub

rdcalerr:
    MsgBox "Error:" & str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    Close #fileno
    On Error GoTo 0
End Sub

Private Function ReadSetupData(fn As String, fileno As Long) As Boolean
    Dim lcnt As Long
    Dim ch As Long
    Dim s As String
    Dim aryTemp As Variant
    Dim aryOverlap As Variant
    Dim strAppliName As String
    Dim strBoardIdn As String
    Dim int_sw As Integer
    Dim Z0 As Double
    Dim strTmp As String
    Dim i As Integer
    Dim seg_cnt As Integer
    Dim RdBdId As Long
    Dim n As Integer
    Dim measSeg As Long
    Dim arg_posi As Long
    Dim arg_cnt As Long
    Dim pio_tbl(MAX_CH) As Integer

    pio_tbl(ACT_CH1) = SP4T_PORT1
    pio_tbl(ACT_CH2) = SP4T_PORT2
    pio_tbl(ACT_CH3) = SP4T_PORT3
    pio_tbl(ACT_CH4) = SP4T_PORT4
    
    '
    ' CSV t@C瑪Ƒ荀ڂϐɓǂݏo܂B
    '
    ReadSetupData = True        'ǂݏoG[EtOEZbg
    On Error GoTo ErrReadFile   'G[̃Wvw
        
    Erase MeasData
    Erase LCR_Meas
    Erase LCR_MeasItem
    Erase LCR_MeasItemNum

    '
    s = cnt_CSV_SEPA_CHAR       'CSVt@C؂R[hw
    
    lcnt = 0                    'ǂݎsJEg
    
    ' Application Name
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    strAppliName = CStr(aryTemp(1))
    
    If UCase(strAppliName) <> UCase(cnt_CHECK_APPLI_NAME) Then GoTo ErrReadFile
    
    ' CSV Sheet Revision
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    strCsvVer = CDbl(aryTemp(1))
        
    ' Product Name
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    NA_ProductName = CStr(aryTemp(1))
    If TcpConnect = True Then
        If 0 = InStr(NA_ConnectProductName, NA_ProductName) Then
            MsgBox "Connect Product Name [ " & NA_ConnectProductName & " ]: " & vbCrLf & vbCrLf & _
                    "Read Product Name [ " & NA_ProductName & " ]", vbOKOnly Or vbCritical
            GoTo ErrProductType
        End If
    End If
    
    'CAL Data File Save/Recall Flag
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
    RdCsvInfo.CalSvRcFlg = int_sw
    
    ' CAL Type (Don't Care / User Define / 3.5mm / 3.5mm(R&S))
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    If strTmp = "Don't@Care" Then      'Ver 2.100 2011/07/14
        CKit.CKitType = 0
    ElseIf strTmp = "Don't Care" Then   'Ver 2.000
        CKit.CKitType = 0
    ElseIf strTmp = "User Define" Then
        CKit.CKitType = 1
    ElseIf strTmp = "3.5mm" Then
        CKit.CKitType = 2
    ElseIf strTmp = "3.5mm(R&S)" Then
        CKit.CKitType = 3
    Else
        GoTo ErrReadFile
    End If
  
    ' User Cal Kit Connect Type (Female/Male)
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    strTmp = CStr(aryTemp(1))
    If strTmp = "Female" Then
        CKit.PortSex = BIS_FEMALE
    Else
        CKit.PortSex = BIS_MALE
    End If
        
    If 0 < InStr(NA_ProductName, "R3760") Then
        'User Cal Kit OPEN Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'OPEN Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_OpenZ0 To Unit_OpenCapC3
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i + 1)))
        Next i
        
        'User Cal Kit SHORT Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'SHORT Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_ShortZ0 To Unit_ShortIndL3
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i - Unit_OpenCapC3)))
        Next i
        
        'User Cal Kit LOAD Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'LOAD Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = Unit_LoadZ0 To Unit_LoadResistance
            Call SetUserDefCalKit_Data(i, CDbl(aryTemp(i - Unit_ShortIndL3)))
        Next i
    Else
        'Standard Cal Kit OPEN Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'OPEN Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        With StdCKit
            Call SetStdCalKit_Data(Unit_OpenR, CDbl(aryTemp(1)))
            Call SetStdCalKit_Data(Unit_OpenL, CDbl(aryTemp(2)))
            Call SetStdCalKit_Data(Unit_OpenC, CDbl(aryTemp(3)))
        End With
        
        'Standard Cal Kit SHORT Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'SHORT Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        With StdCKit
            Call SetStdCalKit_Data(Unit_ShortR, CDbl(aryTemp(1)))
            Call SetStdCalKit_Data(Unit_ShortL, CDbl(aryTemp(2)))
            Call SetStdCalKit_Data(Unit_ShortC, CDbl(aryTemp(3)))
        End With
        
        'Standard Cal Kit LOAD Item Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        'LOAD Calibration data
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        With StdCKit
            Call SetStdCalKit_Data(Unit_LoadR, CDbl(aryTemp(1)))
            Call SetStdCalKit_Data(Unit_LoadL, CDbl(aryTemp(2)))
            Call SetStdCalKit_Data(Unit_LoadC, CDbl(aryTemp(3)))
        End With
    End If
        
    ' PIO-Output Data
    RdCsvInfo.IniPio = BIS_OFF
    

    ' Number Of Channel
    lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
    If cnt_PD_NUMCH_TITLE <> aryTemp(0) Then GoTo ErrReadFile
    RdCsvInfo.ChNum = CLng(aryTemp(1))
    ReDim ChInfo(MAX_CH) As struct_Chinfo   'CḦmۂƏ
    
    If (MAX_CH + 1) < RdCsvInfo.ChNum Then GoTo ErrReadFile
    
    MeasNum = 0
    
    For ch = 0 To RdCsvInfo.ChNum - 1
        ' Channel Title
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        ChInfo(ch).strTitle = aryTemp(1)
        
        'Waveform display
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(1)), int_sw)
        ChInfo(ch).intWaveDisp = int_sw
        
        ' Measurement (A/R, A, R, S21, S11)
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            For n = 0 To frmCH.Option_msr.UBound
                If frmCH.Option_msr(n).Caption = CStr(aryTemp(1)) Then
                    Exit For
                End If
            Next n
            
            If n = 0 Then
                ChInfo(ch).SelectMeas = BIS_MEAS_AR
                ChInfo(ch).SelectMeasType = McrMeas_AR
            ElseIf n = 1 Then
                ChInfo(ch).SelectMeas = BIS_MEAS_A
                ChInfo(ch).SelectMeasType = McrMeas__A
            ElseIf n = 2 Then
                ChInfo(ch).SelectMeas = BIS_MEAS_R
                ChInfo(ch).SelectMeasType = McrMeas__R
            ElseIf n = 3 Then
                ChInfo(ch).SelectMeas = BIS_MEAS_S21
                ChInfo(ch).SelectMeasType = McrMeasS21
            ElseIf n = 4 Then
                ChInfo(ch).SelectMeas = BIS_MEAS_S11
                ChInfo(ch).SelectMeasType = McrMeasS11
            ElseIf n = 5 Then
                If lngExpSwBox <> SWBOX_DPDT Then GoTo ErrReadFile
                ChInfo(ch).SelectMeas = BIS_MEAS_S21
                ChInfo(ch).SelectMeasType = McrMeasS12
            ElseIf n = 6 Then
                If lngExpSwBox <> SWBOX_DPDT Then GoTo ErrReadFile
                ChInfo(ch).SelectMeas = BIS_MEAS_S11
                ChInfo(ch).SelectMeasType = McrMeasS22
            End If
            
        ' CAL Method (Norm/Trans/1 Port)
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        strTmp = CStr(aryTemp(1))
        If strTmp = "Norm" Then
            ChInfo(ch).CorMeth = BIS_CAL_NORM
        ElseIf strTmp = "Trans" Then
            ChInfo(ch).CorMeth = BIS_CAL_TRANS
        ElseIf strTmp = "1 Port" Then
            ChInfo(ch).CorMeth = BIS_CAL_1PORT
        Else
            GoTo ErrReadFile
        End If
        
        If CDbl(cnt_CSV_WRITE_VER1000) < CDbl(strCsvVer) Then
            ' Setting of each port Title
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            ' Port Extension (psec)
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            ChInfo(ch).Correct.PortExtCorrTime = CDbl(aryTemp(1)) * PS
            ' Port Impedance (ohm)
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            ChInfo(ch).ImpZ0 = CDbl(aryTemp(1))
        Else
            ChInfo(ch).Correct.PortExtCorrTime = 0
            ChInfo(ch).ImpZ0 = 50
        End If
                       
        If lngExpSwBox = SWBOX_DPDT Then
            ' PIO-Output Data
            With ChInfo(ch)
                If .SelectMeasType = McrMeasS22 Or .SelectMeasType = McrMeasS12 Then
                    ChInfo(ch).Pio = BIS_ON
                Else
                    ChInfo(ch).Pio = BIS_OFF
                End If
            End With
        Else
            ' PIO-Output Data
            ChInfo(ch).Pio = pio_tbl(ch)
        End If
        
        ' Number of Freq.Segment
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        If cnt_STIM_NUM_TITLE <> aryTemp(0) Then GoTo ErrReadFile

        ChInfo(ch).StimuNum = CInt(aryTemp(1))
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = 0 To ChInfo(ch).StimuNum - 1
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            With CH_Stimu(i, ch)
                .dblFreq1 = CDbl(aryTemp(1)) * Unit_mega
                .dblFreq2 = CDbl(aryTemp(2)) * Unit_mega
                .lngPntN = CLng(aryTemp(3))
                .lngFmode = BIS_FREQ_LIN
                .lngFtype = BIS_FREQ_STRSTP
                .sngPow1 = CDbl(aryTemp(4))
                .sngPow2 = CDbl(aryTemp(5))
                .sngRbw = CLng(CDbl(aryTemp(6)) * Unit_k)
                CH_RbwBk(i, ch) = .sngRbw
                .sngStime = CDbl(aryTemp(7)) * Unit_m
                ChInfo(ch).lngTotP = ChInfo(ch).lngTotP + .lngPntN
            End With
        Next i
                 
        'Number of Trace
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        ChInfo(ch).trcNum = CInt(aryTemp(1))
        
        ReDim Preserve ChInfo(ch).trc(0 To ChInfo(ch).trcNum) As struct_TrcInfo
        arg_posi = 0: arg_cnt = 0
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = 0 To ChInfo(ch).trcNum - 1
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            With ChInfo(ch).trc(i)
                .TrcNo = i
                .strFormat = CStr(aryTemp(1))       'Trace Wave Format "LOGMAG/SWR..."
                .trcFrmt = CnvFormatNameToType(.strFormat)
                ChInfo(ch).WaveFrmt = ChInfo(ch).WaveFrmt Or .trcFrmt
                Call CnvFormatNameToScale(ChInfo(ch).Trace, .strFormat, CDbl(aryTemp(2)), CDbl(aryTemp(3)), CDbl(aryTemp(4)))
                .trcFmtScale = ChInfo(ch).Trace.FmtScale
                
                If CDbl(cnt_CSV_WRITE_VER2000) < CDbl(strCsvVer) And aryTemp(5) <> Empty Then
                    .ArgNo = CLng(aryTemp(5))
                    If .ArgNo <> 0 Then
                        arg_posi = arg_posi Or 2 ^ (.ArgNo - 1) 'Arrangement position 1:1, 2:2, 4:3, 8:4
                    End If
                End If
            End With
        Next i
        If arg_posi <> 0 Then
            If (arg_posi And 2 ^ (McrArgPosi4 - 1)) > 0 Then
                arg_cnt = 4
            ElseIf (arg_posi And 2 ^ (McrArgPosi3 - 1)) > 0 Then
                arg_cnt = 3
            ElseIf (arg_posi And 2 ^ (McrArgPosi2 - 1)) > 0 Then
                If 2 = RdCsvInfo.ChNum Then
                    arg_cnt = 3
                Else
                    arg_cnt = 2
                End If
            Else
                arg_cnt = 1
            End If
        Else
            arg_cnt = 0
        End If
        ChInfo(ch).argNum = arg_cnt
        
        'Number Of Measurement
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        ChInfo(ch).MeasSegNum = CInt(aryTemp(1))

        measSeg = ChInfo(ch).MeasSegNum
        MeasNum = MeasNum + measSeg

        If MeasItemNum < measSeg Then
            MeasItemNum = measSeg
            ReDim Preserve MeasInfo(0 To MAX_CH, 0 To MeasItemNum) As struct_measInfo
        End If
        
        lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
        For i = 0 To measSeg - 1                                    'CH ̑荀ڐ
            lcnt = RdWtData(fileno, lcnt, aryTemp, s, cnt_READ)
            With MeasInfo(ch, i)
                .SegNumb = CLng(aryTemp(0))                         'ZOgԍi_~[j
                If i + 1 <> .SegNumb Then GoTo ErrReadFile
                .title = CStr(aryTemp(1))                           'Measurement Number
                 Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(2)), .JudgeValid) 'Judge Valid(ON)/Invalid(OFF)
                If .JudgeValid = -1 Then GoTo ErrReadFile
                .RefFmtNo = CLng(aryTemp(3))                        'Trace Number
                .TrcNumb = GetTraceNo(ch, ChInfo(ch).trc(.RefFmtNo - 1).strFormat)  'Get BNA Trace Number
                ' Meas. CommandiMAX(0),MIN(1),VAL(2),PWRVAL(3)j
                 ChInfo(ch).WaveFrmt = ChInfo(ch).WaveFrmt Or GetMeasType(cnt_STR_TO_INT, CStr(aryTemp(4)), .MeasType, .dBDown)
                If .MeasType = -1 Then GoTo ErrReadFile
                If .MeasType = McrMeasPWRVAL Then                   'Power Sweep
                    .Start = CDbl(aryTemp(5))                       'START[MHz] -> Pow1 Level[dBm]
                    .Stop = CDbl(aryTemp(6))                        'STOP[MHz]  -> Pow2 Level[dBm]
                Else
                    .Start = CDbl(aryTemp(5)) * Unit_mega           'START[MHz]
                    .Stop = CDbl(aryTemp(6)) * Unit_mega            'STOP[MHz]
                End If
                 
                Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(7)), .LmtDspFlg) 'Limit Line Display (ON/OFF)
                Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(8)), .LwLmtLvlFlg) 'Level Lower Limit Check (ON/OFF)
                Call CnvOnOffSw(cnt_STR_TO_INT, CStr(aryTemp(10)), .UpLmtLvlFlg) 'Level Upper Limit Check (ON/OFF)
                
                If McrMeasVALL <= .MeasType And .MeasType <= McrMeasRESR Then
                    .LwLmtLvl = dblNumCharStrToDbl(CStr(aryTemp(9)))      'Level L LowerL imit
                    .UpLmtLvl = dblNumCharStrToDbl(CStr(aryTemp(11)))     'Level L Upper Limit
                Else
                    .LwLmtLvl = CSng(aryTemp(9))                    'Level other LowerL imit
                    .UpLmtLvl = CSng(aryTemp(11))                   'Level other Upper Limit
                End If
                
                .LwLmtFrq = CDbl(aryTemp(12)) * Unit_mega           'Freq Lower Limit
                .UpLmtFrq = CDbl(aryTemp(13)) * Unit_mega           'Freq Upper Limit
                If .MeasType = McrMeasMAX Or .MeasType = McrMeasMIN Then
                    If .LwLmtFrq <> 0 And .UpLmtFrq <> 0 And .LwLmtFrq = .UpLmtFrq Then .MeasType = McrMeasVAL
                End If
            End With
        Next i
    Next ch
    
    Erase aryTemp
    ReDim MeasData(0 To MAX_CH, 0 To MeasItemNum) As struct_measdata
    ReDim LCR_Meas(0 To MAX_CH, 0 To MeasItemNum) As struct_resonance
    ReDim LCR_MeasItem(0 To MAX_CH, 0 To MeasItemNum, 0 To MeasItemNum) As struct_resonance_meas
    ReDim LCR_MeasItemNum(0 To MAX_CH, 0 To MeasItemNum) As Long

    ReadSetupData = False       'ǂݏotOEZbg
    
ErrEnd:
    On Error GoTo 0 '*** ON ERROR reset ****
    Exit Function

ErrReadFile:
    MsgBox fn & "Error line[ " & CLng(lcnt) & " ]: " + vbCrLf + vbCrLf + CStr(aryTemp(0)), vbOKOnly Or vbCritical
ErrProductType:
    GoTo ErrEnd

End Function

'
'The setting condition data is read from the CSV file.
'
Public Function ReadCsvFile(fn As String) As Boolean
    Dim FileNum As Long
    Dim blnRtn As Boolean
    Dim fn_cal As String
    
    ReadCsvFile = False
    FileNum = FreeFile
    Open fn For Input As #FileNum
        blnRtn = ReadSetupData(fn, FileNum)
    Close #FileNum
    
    ReadCsvFile = blnRtn
End Function

Public Sub SaveTraceData(ch As Long, fn As String)
    Dim FileNum As Long
    Dim lcnt As Long
    Dim s As String
    Dim i As Integer
    Dim points As Long
    Dim strTemp As Variant
    Dim TrcFmt As Long
    '
    On Error GoTo ErrSaveTrace
    
    FileNum = FreeFile
    
    lcnt = 0
    s = cnt_CSV_SEPA_CHAR
    points = ChInfo(ch).lngTotP - 1
    TrcFmt = ChInfo(ch).WaveFrmt
    Open fn For Output As #FileNum
        Write #FileNum, "No.", "Freq",
        If BufLvl(0, lngACh) <> ERR_VALUE Then  'p[|?
            Write #FileNum, "POWER"
        Else
            If (TrcFmt And WAVE_FORMAT_LOGMAG) <> 0 Then
                If TrcFmt - WAVE_FORMAT_LOGMAG <> 0 Then
                    Write #FileNum, "LOGMAG",
                Else
                    Write #FileNum, "LOGMAG"
                End If
            End If
            If (TrcFmt And WAVE_FORMAT____SWR) <> 0 Then
                Write #FileNum, "SWR"
            End If
        End If
        lcnt = RdWtData(FileNum, lcnt, strTemp, s, cnt_SAVE)
        For i = 0 To points
            If BufLvl(i, lngACh) <> ERR_VALUE Then  'p[|?
                strTemp = strTemp & s & Format(BufLvl(i, ch), cnt_LEVL_TO_STR)
            Else
                Write #FileNum, CStr(i + 1), Format(BufFrq(i, ch), cnt_FREQ_TO_STR),
                If (TrcFmt And WAVE_FORMAT_LOGMAG) <> 0 Then
                    If TrcFmt - WAVE_FORMAT_LOGMAG <> 0 Then
                        Write #FileNum, Format(BufLgm(i, ch), cnt_LEVL_TO_STR),
                    Else
                        Write #FileNum, Format(BufLgm(i, ch), cnt_LEVL_TO_STR)
                    End If
                End If
                If (TrcFmt And WAVE_FORMAT____SWR) <> 0 Then
                    Write #FileNum, Format(BufSwr(i, ch), cnt_LEVL_TO_STR)
                End If
            End If
        Next i
    Close #FileNum
    
    On Error GoTo 0
    Exit Sub

ErrSaveTrace:
    Close #FileNum
    MsgBox fn & "Error:" & str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    On Error GoTo 0

End Sub

'
'   Save Result Header information
'
Public Function SaveMeasData(fn As String, fileno As Long) As Boolean
    Dim ch As Long
    Dim s As String
    Dim lcnt As Long
    Dim strTemp As Variant
    Dim i As Integer
    Dim str_sw As String
    Dim act_format As Integer
    Dim view_wave As Integer
    Dim plog_max As Long
    Dim plog_min As Long
    Dim p0deg As Long
    Dim pdel_max As Long
    Dim pdel_min As Long
    Dim pswr_max As Long
    Dim pswr_min As Long

    If FileDlg.FileExists(fn) = True Then
        On Error Resume Next
        Kill fn
        On Error GoTo 0
    End If
    '
    On Error GoTo ErrSaveFile

    s = cnt_CSV_SEPA_CHAR

    lcnt = 0

    ' Application Name
    strTemp = cnt_APP_NAME_TITLE & s & cnt_CHECK_APPLI_NAME
    Write #fileno, cnt_APP_NAME_TITLE, cnt_CHECK_APPLI_NAME
    
    ' CSV Sheet Revsion
    strTemp = cnt_CSV_SHET_TITLE & s & strCsvVer
    Write #fileno, cnt_CSV_SHET_TITLE, strCsvVer

    ' Board Number
    strTemp = cnt_BD__NUMB_TITLE & s & frmSetup.Combo_bd.ListIndex
    Write #fileno, cnt_BD__NUMB_TITLE, CStr(frmSetup.Combo_bd.ListIndex)

    ' IP Address
    strTemp = cnt_IP__ADDR_TITLE & s & frmSetup.Text_con.Text
    Write #fileno, cnt_IP__ADDR_TITLE, frmSetup.Text_con.Text

    ' Product Name
    strTemp = cnt_PD__NAME_TITLE & s & NA_ProductName
    Write #fileno, cnt_PD__NAME_TITLE, NA_ProductName

    ' Serial Number
    strTemp = cnt_PD_SERNO_TITLE & s & NA_SerialNumber
    Write #fileno, cnt_PD_SERNO_TITLE, NA_SerialNumber

    On Error GoTo 0
    Exit Function

ErrSaveFile:
    Close #fileno
    MsgBox fn & "Error:" & str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    On Error GoTo 0
End Function

'
'Check File time stamp
'
Public Function ChkFileTimeStamp(ByRef f1time As Date, ByRef f2time As Date) As Boolean

    ChkFileTimeStamp = True
    If f1time > f2time Then
        ChkFileTimeStamp = False
    End If

End Function

'
'get File time stamp
'
Public Sub GetFileTimeStamp(ByRef fn As String, ByRef ftime As Date)
    ftime = FileDateTime(fn)
End Sub

'
Public Sub SaveCalFile(ByVal mx_ch As Long, ByVal fn As String)
    Dim fileno As Long
    Dim i As Integer
    Dim ch As Integer

    fn = Mid(fn, 1, Len(fn) - 3)
    fn = fn & "bin"
    On Error GoTo svcalerr
    If FileDlg.FileExists(fn) = True Then
        Kill fn
    End If
    
    fileno = FreeFile
    '
    Open fn For Binary Access Write As #fileno Len = Len(ChInfo(ACT_CH1).Correct.cal1(0))
        For ch = ACT_CH1 To mx_ch - 1
            With ChInfo(ch)
                For i = 0 To .lngTotP - 1
                    With .Correct
                        Put #fileno, , .cal1(i * 2)
                        Put #fileno, , .cal1(i * 2 + 1)
                        Put #fileno, , .cal2(i * 2)
                        Put #fileno, , .cal2(i * 2 + 1)
                        Put #fileno, , .cal3(i * 2)
                        Put #fileno, , .cal3(i * 2 + 1)
                    End With
                Next i
            End With
        Next ch
    Close #fileno
    On Error GoTo 0
    Exit Sub

svcalerr:
    MsgBox "Error:" & str(Err.Number) & vbCrLf & Error(Err.Number), vbOKOnly Or vbCritical
    Close #fileno
    On Error GoTo 0
End Sub


'
'The setting condition data and the measurement data is write in the CSV file.
'
Public Function SaveCsvFile(fn As String) As Boolean
    Dim FileNum As Long
    Dim blnRtn As Boolean
    '
    SaveCsvFile = False
    FileNum = FreeFile
    Open fn For Output As #FileNum
        blnRtn = SaveMeasData(fn, FileNum)
    Close #FileNum
    SaveCsvFile = blnRtn
End Function

'
' LCR Measurement Data entry
'
Private Sub Ent_LCR_Meas(ByRef inf_lcr As struct_resonance, ByRef cnt As Long, st As Double, sp As Double, p_st As Long, p_sp As Long, ByVal MeasNo As Long)

    With inf_lcr
        .EntMeasNo = MeasNo
        .f_start = st
        .f_stop = sp
        .p_start = p_st
        .p_stop = p_sp
    End With
    
    cnt = cnt + 1
    
End Sub


Private Sub Ent_LCR_MeasItem(ByRef inf_lcrItem As struct_resonance_meas, ByRef cnt As Long, ByVal MeasNo As Long, ByVal SameNo As Long, typ As Long)

    With inf_lcrItem
        .MeasNo = MeasNo
        .SameMeasNo = SameNo
        .Type = typ
    End With
    
    cnt = cnt + 1
    
End Sub

'
' Check entry LCR measurement information
'
Public Sub Chk_Ent_LCR_Meas(ch_no As Long, MeasNo As Long, st As Double, sp As Double, p_st As Long, p_sp As Long, typ As Long)
    Dim cnd As Long 'entry condition counter
    Dim itm As Long 'same condition measurement no.
    Dim n As Long   'number of entries of each CH
    
    n = LCR_MeasNum(ch_no)
    itm = LCR_MeasItemNum(ch_no, n)
    If n = 0 Then
        Call Ent_LCR_Meas(LCR_Meas(ch_no, n), LCR_MeasNum(ch_no), st, sp, p_st, p_sp, MeasNo)
        Call Ent_LCR_MeasItem(LCR_MeasItem(ch_no, n, itm), LCR_MeasItemNum(ch_no, n), MeasNo, MeasNo, typ)
    Else
        For cnd = 0 To n - 1
            itm = LCR_MeasItemNum(ch_no, cnd)
            With LCR_Meas(ch_no, cnd)
                If st <> .f_start Or sp <> .f_stop Then
                    Call Ent_LCR_Meas(LCR_Meas(ch_no, cnd), LCR_MeasNum(ch_no), st, sp, p_st, p_sp, MeasNo)
                    Call Ent_LCR_MeasItem(LCR_MeasItem(ch_no, cnd, itm), LCR_MeasItemNum(ch_no, cnd), MeasNo, .EntMeasNo, typ)
                    Exit For
                ElseIf st = .f_start And sp = .f_stop Then
                    Call Ent_LCR_MeasItem(LCR_MeasItem(ch_no, cnd, itm), LCR_MeasItemNum(ch_no, cnd), MeasNo, .EntMeasNo, typ)
                End If
            End With
        Next cnd
    End If
        
End Sub


'
'LCR @ӏ
'
Public Sub LCR_MeasPackage(ByVal ch_num As Long)
Dim i As Long
Dim ii As Long
Dim MeasNo As Long  'LCR ̓o^ԍ̔rAo^p

    For i = 0 To ch_num - 1
        MeasNo = 1              'CH̑Jnԍ -> Call MeasExe(ch, measct + 1, ...)@bna_test() : MdlMain.bas
        LCR_MeasNum(i) = 0
        For ii = 0 To ChInfo(i).MeasSegNum - 1
            With MeasInfo(i, ii)
                Select Case .MeasType
                    Case McrMeasRESMIN To McrMeasRESR
                        Call Chk_Ent_LCR_Meas(i, MeasNo, .Start, .Stop, .PStart, .PStop, .MeasType)
                End Select
            End With
            MeasNo = MeasNo + 1 ' 荀ڂ̒ʂԍ
        Next ii
    Next i

End Sub

